/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.availability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.client.gui.select.GuiDialogSelection;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumAvailabilityDialog;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.Dialog;

public class SubGuiNpcAvailabilityDialog
extends SubGuiInterface
implements ICustomScrollListener,
ISubGuiListener {
    protected final Availability availability;
    protected final Map<String, EnumAvailabilityDialog> dataEnum = new HashMap<String, EnumAvailabilityDialog>();
    protected final Map<String, Integer> dataIDs = new HashMap<String, Integer>();
    protected GuiCustomScroll scroll;
    protected String select = "";

    public SubGuiNpcAvailabilityDialog(Availability availability) {
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 217;
        this.closeOnEsc = true;
        this.availability = availability;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                if (this.select.isEmpty()) {
                    return;
                }
                EnumAvailabilityDialog ead = EnumAvailabilityDialog.values()[button.getValue()];
                int id = this.dataIDs.get(this.select);
                this.availability.dialogues.put(id, ead);
                Dialog dialog = DialogController.instance.dialogs.get(this.dataIDs.get(this.select));
                this.select = "ID:" + id + " - ";
                this.select = dialog == null ? this.select + "\u00a74" + new TextComponentTranslation("quest.notfound", new Object[0]).func_150254_d() : this.select + "\u00a77" + dialog.getCategory().getName() + "/" + '\u00a7' + "r" + dialog.getName() + '\u00a7' + "7 (" + '\u00a7' + "9" + new TextComponentTranslation(("availability." + (Object)((Object)ead)).toLowerCase(), new Object[0]).func_150254_d() + '\u00a7' + "7)";
                this.func_73866_w_();
                break;
            }
            case 1: {
                this.setSubGui(new GuiDialogSelection(this.select.isEmpty() ? 0 : this.dataIDs.get(this.select), 0));
                break;
            }
            case 2: {
                this.availability.dialogues.remove(this.dataIDs.get(this.select));
                this.select = "";
                this.func_73866_w_();
                break;
            }
            case 3: {
                this.save();
                this.func_73866_w_();
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        super.close();
        ArrayList<Integer> delete = new ArrayList<Integer>();
        for (int id : this.availability.dialogues.keySet()) {
            if (this.availability.dialogues.get(id) != EnumAvailabilityDialog.Always) continue;
            delete.add(id);
        }
        for (int id : delete) {
            this.availability.dialogues.remove(id);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        GuiNpcLabel label = new GuiNpcLabel(1, "availability.available", this.guiLeft, this.guiTop + 4);
        label.setCenter(this.xSize);
        this.addLabel(label);
        GuiNpcButton button = new GuiNpcButton(66, this.guiLeft + 6, this.guiTop + 192, 70, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 6);
            this.scroll.setSize(this.xSize - 12, this.ySize - 66);
        }
        this.dataIDs.clear();
        this.dataEnum.clear();
        for (int id : this.availability.dialogues.keySet()) {
            String key = "ID:" + id + " - ";
            Dialog dialog = DialogController.instance.dialogs.get(id);
            key = dialog == null ? key + "\u00a74" + new TextComponentTranslation("quest.notfound", new Object[0]).func_150254_d() : key + "\u00a77" + dialog.getCategory().getName() + "/" + '\u00a7' + "r" + dialog.getName() + '\u00a7' + "7 (" + '\u00a7' + "9" + new TextComponentTranslation(("availability." + (Object)((Object)this.availability.dialogues.get(id))).toLowerCase(), new Object[0]).func_150254_d() + '\u00a7' + "7)";
            this.dataIDs.put(key, id);
            this.dataEnum.put(key, this.availability.dialogues.get(id));
        }
        if (!this.select.isEmpty() && !this.dataIDs.containsKey(this.select)) {
            this.select = "";
        }
        this.scroll.setList(new ArrayList<String>(this.dataIDs.keySet()));
        this.scroll.guiLeft = this.guiLeft + 6;
        this.scroll.guiTop = this.guiTop + 14;
        if (!this.select.isEmpty()) {
            this.scroll.setSelected(this.select);
        }
        this.addScroll(this.scroll);
        int p = 0;
        if (!this.select.isEmpty()) {
            switch (this.dataEnum.get(this.select)) {
                case After: {
                    p = 1;
                    break;
                }
                case Before: {
                    p = 2;
                    break;
                }
            }
        }
        button = new GuiNpcButton(0, this.guiLeft + 6, this.guiTop + this.ySize - 46, 50, 20, new String[]{"availability.always", "availability.after", "availability.before"}, p);
        button.setHoverText("availability.hover.enum.type", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, this.guiLeft + 58, this.guiTop + this.ySize - 46, 170, 20, "availability.select");
        button.setHoverText("availability.hover.dialog", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.guiLeft + 230, this.guiTop + this.ySize - 46, 20, 20, "X");
        button.setHoverText("availability.hover.remove", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(3, this.guiLeft + this.xSize - 76, this.guiTop + 192, 70, 20, "availability.more");
        button.setEnabled(!this.select.isEmpty());
        button.setHoverText("availability.hover.more", new Object[0]);
        this.addButton(button);
        this.updateGuiButtons();
    }

    @Override
    public void save() {
        if (this.select.isEmpty()) {
            return;
        }
        EnumAvailabilityDialog ead = EnumAvailabilityDialog.values()[this.getButton(0).getValue()];
        int id = this.dataIDs.get(this.select);
        if (ead != EnumAvailabilityDialog.Always) {
            this.availability.dialogues.put(id, ead);
            this.dataEnum.put(this.select, ead);
        } else {
            this.availability.dialogues.remove(id);
        }
        this.select = "";
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.select = scroll.getSelected();
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        this.setSubGui(new GuiDialogSelection(this.dataIDs.get(select), 0));
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        GuiDialogSelection selector = (GuiDialogSelection)subgui;
        if (selector.selectedDialog == null) {
            return;
        }
        if (!this.select.isEmpty()) {
            this.availability.dialogues.remove(this.dataIDs.get(this.select));
        }
        this.select = "ID:" + selector.selectedDialog.id + " - " + '\u00a7' + "7" + selector.selectedCategory.getName() + "/" + '\u00a7' + "r" + selector.selectedDialog.getName() + '\u00a7' + "7 (" + '\u00a7' + "9" + new TextComponentTranslation("availability.after", new Object[0]).func_150254_d() + '\u00a7' + "7)";
        this.availability.dialogues.put(selector.selectedDialog.id, EnumAvailabilityDialog.After);
        this.func_73866_w_();
    }

    private void updateGuiButtons() {
        int p = 0;
        this.getButton(1).setDisplayText("availability.selectdialog");
        Dialog dialog = null;
        if (!this.select.isEmpty()) {
            dialog = DialogController.instance.dialogs.get(this.dataIDs.get(this.select));
            p = this.dataEnum.get(this.select).ordinal();
        }
        this.getButton(0).setDisplay(p);
        this.getButton(0).setEnabled(!this.select.isEmpty());
        this.getButton(1).setEnabled(p != 0 || this.select.isEmpty());
        this.getButton(1).setDisplayText(dialog == null ? "availability.select" : dialog.getName());
        this.getButton(2).setEnabled(p != 0);
    }
}

